#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

// Function to solve 0-1 Knapsack problem using DP
int knapsackDP(int W, vector<int> weight, vector<int> profit, int n) {
    vector<vector<int>> dp(n + 1, vector<int>(W + 1, 0));

    // Build table dp[][] bottom-up
    for (int i = 1; i <= n; i++) {
        for (int w = 1; w <= W; w++) {
            if (weight[i - 1] <= w) {
                dp[i][w] = max(profit[i - 1] + dp[i - 1][w - weight[i - 1]],
                               dp[i - 1][w]);
            } else {
                dp[i][w] = dp[i - 1][w];
            }
        }
    }

    // Display DP table (for understanding)
    cout << "\nDP Table:\n";
    for (int i = 0; i <= n; i++) {
        for (int w = 0; w <= W; w++) {
            cout << dp[i][w] << "\t";
        }
        cout << endl;
    }

    return dp[n][W]; // maximum profit
}

int main() {
    int n, W;
    cout << "Enter number of items: ";
    cin >> n;

    vector<int> profit(n), weight(n);
    cout << "Enter profit and weight for each item:\n";
    for (int i = 0; i < n; i++) {
        cin >> profit[i] >> weight[i];
    }

    cout << "Enter Knapsack capacity: ";
    cin >> W;

    int maxProfit = knapsackDP(W, weight, profit, n);
    cout << "\nMaximum Profit = " << maxProfit << endl;

    return 0;
}
